//%attributes = {}
// Method: ld_ GRAPH_COLUMN_SET
// 2010.11.05-03:17:07 / Pasi Mankinen
// © Copyright 2010 Manage Applications
// Purpose: 
//  calculate graph array value, complement color when selected
// see: ld_ GRAPH_COLUMN_SET_PRF_PARSE
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_LONGINT:C283($1; $ld_lTbl; $2; $ld_lIndex; $3; $ld_lSelected)
C_LONGINT:C283($ld_lGraphWidth; $ld_lR; $ld_lG; $ld_lB)
C_TEXT:C284($ld_tGraphColor; $ld_tGraphColorBorder)
C_POINTER:C301($ld_pCalcArr; $ld_pMaxValueVar; $ld_pGraphArr; $ld_pStateArr)
C_PICTURE:C286(ld_gTmpPict)
C_REAL:C285($ld_rValue)


If (<>ld_lGraphColumnShow>0)  //PM: 2010-11-05
	
	ld_ TRACK_TIME_GRAPH_SET($1; $2; $3)  // Modified by: MG_PM (2011-10-05T20:09:10)
	
	$ld_lTbl:=$1
	$ld_lIndex:=$2
	$ld_lSelected:=$3
	
	Case of 
		: ($ld_lTbl=wo_kTbl)  //work arr
			$ld_pCalcArr:=Get pointer:C304(<>ld_tGraphCalcArrayWork)
			$ld_pMaxValueVar:=-><>ld_rGraphMaxValueProductState
			$ld_pGraphArr:=->ld_work_agGraph
			$ld_pStateArr:=->ld_work_asWork_Phase_State
		: ($ld_lTbl=wos_kTbl)  //phase arr
			$ld_pCalcArr:=Get pointer:C304(<>ld_tGraphCalcArrayPhase)
			$ld_pMaxValueVar:=-><>ld_rGraphMaxValuePhase
			$ld_pGraphArr:=->ld_phase_agGraph
			$ld_pStateArr:=->ld_phase_atWork_Phase_State
		: ($ld_lTbl=pr_kTbl)  //production status
			$ld_pCalcArr:=Get pointer:C304(<>ld_tGraphCalcArrayProductState)
			$ld_pMaxValueVar:=-><>ld_rGraphMaxValueProductState
			$ld_pGraphArr:=->ldst_pr_agGraph
			$ld_pStateArr:=_ptr Nil  // what array?
		Else 
			TRACE:C157
	End case 
	
	If (Not:C34(Is nil pointer:C315($ld_pCalcArr)))
		$ld_rValue:=$ld_pCalcArr->{$ld_lIndex}
		$ld_lDrawWidth:=Round:C94(Abs:C99($ld_rValue/$ld_pMaxValueVar->)*<>ld_lGraphWidth; 0)
		If ($ld_lDrawWidth><>ld_lGraphWidth)
			$ld_lDrawWidth:=<>ld_lGraphWidth
		Else 
			IDLE:C311  //0 - <>ld_lGraphWidth
		End if 
		
		If ($ld_lDrawWidth<=0)
			$ld_pGraphArr->{$ld_lIndex}:=$ld_pGraphArr->{$ld_lIndex}*0
		Else 
			
			$ld_tGraphColor:=""
			If (Not:C34(Is nil pointer:C315($ld_pStateArr)))
				If ($ld_pStateArr->{$ld_lIndex}=<>ld_tStateFinished)
					$ld_tGraphColorBorder:="grey"
					$ld_tGraphColor:="grey:60"
				End if 
			End if 
			
			Case of 
				: ($ld_tGraphColor#"")
					IDLE:C311  // grey
				: (($ld_rValue<0) & ($ld_lSelected=0))  // negative not selected
					$ld_tGraphColorBorder:=<>ld_tGraphColorNegBorder
					$ld_tGraphColor:=<>ld_tGraphColorNeg
				: ($ld_rValue<0)  // negative selected
					$ld_tGraphColorBorder:=<>ld_tGraphColorNegBorderSel
					$ld_tGraphColor:=<>ld_tGraphColorNegSel
					
					// $ld_rValue must be >=0 here
				: (($ld_rValue<<>ld_rGraphColor1) & ($ld_lSelected=0))  // 0-7 not selected
					$ld_tGraphColorBorder:=<>ld_tGraphColorPosBorder1
					$ld_tGraphColor:=<>ld_tGraphColorPos1
				: (($ld_rValue<<>ld_rGraphColor1) & ($ld_lSelected=1))  // 0-7
					$ld_tGraphColorBorder:=<>ld_tGraphColorPosBorderSel1
					$ld_tGraphColor:=<>ld_tGraphColorPosSel1
					
				: (($ld_rValue<<>ld_rGraphColor2) & ($ld_lSelected=0))  // 8-30 not selected
					$ld_tGraphColorBorder:=<>ld_tGraphColorPosBorder2
					$ld_tGraphColor:=<>ld_tGraphColorPos2
				: (($ld_rValue<<>ld_rGraphColor2) & ($ld_lSelected=1))  // 8-30
					$ld_tGraphColorBorder:=<>ld_tGraphColorPosBorderSel2
					$ld_tGraphColor:=<>ld_tGraphColorPosSel2
					
				: ($ld_lSelected=0)  //must be positive here
					$ld_tGraphColorBorder:=<>ld_tGraphColorPosBorder
					$ld_tGraphColor:=<>ld_tGraphColorPos
				Else   // positive selected
					$ld_tGraphColorBorder:=<>ld_tGraphColorPosBorderSel
					$ld_tGraphColor:=<>ld_tGraphColorPosSel
			End case 
			
			If (($ld_tGraphColorBorder="") | ($ld_tGraphColor=""))
				TRACE:C157
			End if 
			//_qd_INIT 
			//_qd_OPEN PICTURE (0;0;<>ld_lGraphWidth;<>ld_lGraphHeigth;kTrue)
			C_TEXT:C284($ld_tSvgRef; $ldro_tSvgObject; $ldro_tColorListBackground)
			
			//If ($ld_tSvgRef#"")
			//SVG_CLEAR ($ld_tSvgRef)
			//End if 
			
			$ld_tSvgRef:=SVG_New(<>ld_lGraphWidth; <>ld_lGraphHeigth)
			// <>ld_tGraphBackgroundColor := <>_tBackgroundColor
			//  <>_tBackgroundColor is different for mac / win / ( win7 ? )
			$ldro_tSvgObject:=SVG_New_rect($ld_tSvgRef; 0; 0; <>ld_lGraphWidth; <>ld_lGraphHeigth; 0; 0; <>ld_tGraphBackgroundColor; <>ld_tGraphBackgroundColor; 0)  // grey background, otherwise would be white
			
			//If (<>ld_tGraphBackgroundColor#"")
			//$ld_lR:=_long_ HexToLong (_str Parse (<>ld_tGraphBackgroundColor;",";1))
			//$ld_lG:=_long_ HexToLong (_str Parse (<>ld_tGraphBackgroundColor;",";2))
			//$ld_lB:=_long_ HexToLong (_str Parse (<>ld_tGraphBackgroundColor;",";3))
			//_qd_RGB BACKGROUND COLOR ($ld_lR;$ld_lG;$ld_lB)
			//End if 
			
			//$ld_lR:=_long_ HexToLong (_str Parse ($ld_tGraphColor;",";1))
			//$ld_lG:=_long_ HexToLong (_str Parse ($ld_tGraphColor;",";2))
			//$ld_lB:=_long_ HexToLong (_str Parse ($ld_tGraphColor;",";3))
			//_qd_RGB FOREGROUND COLOR ($ld_lR;$ld_lG;$ld_lB)  //Blue/Yellow, normal color if not clicked,  complement when clicked, from prefs
			If ($ld_pCalcArr->{$ld_lIndex}<0)
				$ld_lDrawWidth:=<>ld_lGraphWidth-$ld_lDrawWidth
				//_qd_PAINT RECT ($ld_lDrawWidth;<>ld_lGraphBarTop;<>ld_lGraphWidth;<>ld_lGraphBarHeigth)
				//$ldro_tSvgObject:=SVG_New_rect ($ld_tSvgRef;$ld_lDrawWidth;<>ld_lGraphBarTop;<>ld_lGraphWidth;<>ld_lGraphBarHeigth;0;0;$ld_tGraphColor)  //;$ld_tGraphColor;0)  
				$ldro_tSvgObject:=SVG_New_rect($ld_tSvgRef; $ld_lDrawWidth; <>ld_lGraphBarTop; <>ld_lGraphWidth; <>ld_lGraphBarHeigth; 0; 0; $ld_tGraphColorBorder; $ld_tGraphColor)  //;$ld_tGraphColor;0)  
				
			Else 
				//_qd_PAINT RECT (<>ld_lGraphLeft;<>ld_lGraphBarTop;$ld_lDrawWidth;<>ld_lGraphBarHeigth)
				//$ldro_tSvgObject:=SVG_New_rect ($ld_tSvgRef;<>ld_lGraphLeft;<>ld_lGraphBarTop;$ld_lDrawWidth;<>ld_lGraphBarHeigth;0;0;$ld_tGraphColor)  //;$ld_tGraphColor;0)  
				$ldro_tSvgObject:=SVG_New_rect($ld_tSvgRef; <>ld_lGraphLeft; <>ld_lGraphBarTop; $ld_lDrawWidth; <>ld_lGraphBarHeigth; 0; 0; $ld_tGraphColorBorder; $ld_tGraphColor)  //;$ld_tGraphColor;0)  
				
			End if 
			If (<>ld_rGraphFontSize>0)
				//
				//If (<>ld_tGraphFontColor#"")
				//$ld_lR:=_long_ HexToLong (_str Parse (<>ld_tGraphFontColor;",";1))
				//$ld_lG:=_long_ HexToLong (_str Parse (<>ld_tGraphFontColor;",";2))
				//$ld_lB:=_long_ HexToLong (_str Parse (<>ld_tGraphFontColor;",";3))
				//  //_qd_RGB FOREGROUND COLOR ($ld_lR;$ld_lG;$ld_lB)  //Blue/Yellow, normal color if not clicked,  complement when clicked, from prefs
				//
				//End if 
				
				//<>ld_tGraphFont:=Font number(<>ld_tGraphFont)  //name to num
				//_qd_TEXT FONT (<>ld_tGraphFont), or v12: _qd_TEXT FONT (Font number(<>ld_tGraphFont)) 
				//_qd_TEXT SIZE (<>ld_rGraphFontSize)
				//_qd_TEXT FACE (Plain)
				//_qd_MOVE TO (<>ld_lGraphTextLeft;<>ld_lGraphTextTop+Round(<>ld_rGraphFontSize;0))  //<>ld_lGraphBarTop
				//_qd_DRAW STRING (String($ld_rValue;"|0d"))
				
				//SVG_SET_FONT_FAMILY (svgObject;font)
				//SVG_SET_FONT_SIZE (svgObject;size)
				//SVG_SET_FONT_STYLE (svgObject; style)
				//SVG_New_text (parentSVGObject; text{; x{; y{; font{; size{; style{; alignment{; color{; rotation{; lineSpacing{; stretching}}}}}}}}}})  SVG_Ref
				
				$ldro_tSvgObject:=SVG_New_text($ld_tSvgRef; String:C10($ld_rValue; "|0d"); <>ld_lGraphTextLeft; <>ld_lGraphTextTop; <>ld_tGraphFont; <>ld_rGraphFontSize; Plain:K14:1; Align left:K42:2; <>ld_tGraphFontColor)
				//$ldro_tSvgObject:=SVG_New_textArea ($ld_tSvgRef;String($ld_rValue;"|0d");<>ld_lGraphTextLeft;<>ld_lGraphTextTop;<>ld_lGraphWidth;<>ld_lGraphBarHeigth;<>ld_tGraphFont;<>ld_rGraphFontSize)  //;Plain;Align left)  //;<>ld_tGraphFontColor)
				//; rotation{; lineSpacing{; stretching}}}}}}}}}})  SVG_Ref
				
				//The optional style parameter gives information about the character style used. I
				//0=Plain
				//1=Bold
				//2=Italic
				//4=Underline
				//8=Strikethrough
				
				//The optional alignment parameter can be used to set the type of alignment to be 
				//1=Align default(left)
				//2=Align left
				//3=Center
				
				//SVG_New_textArea also has
				//4=Align right
				//5=Justify
				
			End if 
			//_qd_CLOSE PICTURE 
			//_qd_PICTURE TO VARIABLE DIRECT (->ld_gTmpPict)
			SVG EXPORT TO PICTURE:C1017($ld_tSvgRef; ld_gTmpPict; Own XML data source:K45:18)
			//SVG_CLEAR ($ld_tSvgRef)// may not use id Own XML Data Source is used
			$ld_tSvgRef:=""
			
			//CONVERT PICTURE(ld_gTmpPict;".png")
			
			$ld_pGraphArr->{$ld_lIndex}:=ld_gTmpPict
			ld_gTmpPict:=ld_gTmpPict*0
			//_qd_CLEAR PICTURE 
			
		End if 
		
	End if 
End if 

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 
